package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "矛盾纠纷状态统计分析已结案")
public class ConflictCaseEndResponseDTO implements Serializable {

  private static final long serialVersionUID = 1735919555489820517L;

  @ApiModelProperty(notes = "已结案件", example = "150")
  private Integer caseEndCount;

  @ApiModelProperty(notes = "调解成功", example = "100")
  private Integer caseSuccessCount;

  @ApiModelProperty(notes = "调解失败", example = "50")
  private Integer caseFailCount;
}