package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @ClassName ConflictStatusAnalysisResponseDTO
 * @Description
 * @Author xiet
 * @DATE 2020/10/28 11:02 AM
 * @VERSION 1.0
 **/
@Data
@ApiModel(description = "矛盾纠纷状态统计报表返回数据")
public class ConflictStatusAnalysisResponseDTO implements Serializable {

  private static final long serialVersionUID = 7197822290547943095L;

  @ApiModelProperty(notes = "名称", example = "机构，调解员名称")
  private String name;

  @ApiModelProperty(notes = "自主登记数", example = "100")
  private Integer commonCaseCount;

  @ApiModelProperty(notes = "工作人员登记数", example = "50")
  private Integer workCaseCount;

  @ApiModelProperty(notes = "收案数", example = "200")
  private Integer caseApplyCount;

  @ApiModelProperty(notes = "案件受理数", example = "50")
  private Integer caseAcceptCount;

  @ApiModelProperty(notes = "案件未受理数", example = "50")
  private Integer caseNotAcceptCount;

  @ApiModelProperty(notes = "待调解案件数", example = "50")
  private Integer casePendMediationCount;

  @ApiModelProperty(notes = "调解中案件数", example = "50")
  private Integer caseMediatingCount;

  @ApiModelProperty(notes = "调解成功案件数", example = "50")
  private Integer caseSuccessCount;

  @ApiModelProperty(notes = "调解失败案件数", example = "50")
  private Integer caseFailCount;

  @ApiModelProperty(notes = "调解成功率", example = "50%")
  private String caseSuccessRate;

  @ApiModelProperty(notes = "结案数", example = "100")
  private Integer caseEndCount;
}
