package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "平台概览用户案件量折线图返回数据")
public class PlatformOverviewResponseDTO implements Serializable {

  private static final long serialVersionUID = 6332946564638507597L;

  @ApiModelProperty(notes = "日期", example = "2021-12-09")
  private String dateStr;

  @ApiModelProperty(notes = "每日新增案件量", example = "10")
  private Integer caseCount;

  @ApiModelProperty(notes = "每日新增用户量", example = "10")
  private Integer userCount;
}
