package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.dto.CaseUserAgentDTO;
import com.beiming.normandy.event.dto.MediationAgentMaterialDTO;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 保存案件用户人员
 * @Author: caiwei
 * @Date: Created 2018-11-05
 */
@Data
public class SaveCaseUserResDTO implements Serializable {

  private static final long serialVersionUID = -7748793878062769697L;

  /**
   * 人员id
   */
  private Long id;

  /**
   * 当事人用户id
   */
  private Long userId;

  /**
   * 当事人类型
   */
  private String caseUserType;

  /**
   * 当事人名称
   */
  private String userName;

  /**
   * 代理人用户id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理权限或者被代理人类型，agentType传CLIENT_AGENT，这里就传代理权限；agentType传LEGAL_AGENT，这里就传被代理人类型
   */
  private String agentTypeChild;

  /**
   * 与当事人关系
   */
  private String relationshipWithParties;

  /**
   * 代理人名称
   */
  private String agentName;

  /**
   * 用户排序
   */
  private Integer userOrder;

  /**
   * 代理人材料
   */
  private List<MediationAgentMaterialDTO> relationshipMaterials;

  /**
   * 代理人
   */
  private List<CaseUserAgentDTO> caseUserAgentList;


}
