package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.constant.ConsultancyValidationMessage;
import com.beiming.normandy.event.dto.requestdto.dispute.ChangeToCounselorReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputeFileReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputeLawCaseReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputeReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputeReqPageListDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputeRoomMemberReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputesChatWinReqDTO;
import com.beiming.normandy.event.dto.requestdto.dispute.DisputesUserRelationReqDTO;
import com.beiming.normandy.event.dto.responsedto.dispute.CounselorDisputesCountMapResDTO;
import com.beiming.normandy.event.dto.responsedto.dispute.DisputesChatWinResDTO;
import com.beiming.normandy.event.dto.responsedto.dispute.DisputesResDTO;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-06-27 17:12
 */
@Valid
@FeignClient(value = "normandy-event", path = "/disputes", configuration = FeignConfig.class, contextId = "DisputesApi")
public interface DisputesApi {

  /**
   * 新增纠纷
   */
  @RequestMapping(value = "addDispute", method = RequestMethod.POST)
  DubboResult<Long> addDispute(@RequestBody @Valid DisputeReqDTO disputeReqDTO);


  /**
   * 人工咨询-证据列表
   */
  @RequestMapping(value = "queryDisputeFileJson", method = RequestMethod.POST)
  DubboResult<String> queryDisputeFileJson(
      @Valid @NotNull(message = ConsultancyValidationMessage.DISPUTE_ID_NOT_BLANK) Long disputeId);


  /**
   * 查询咨询列表
   */
  @RequestMapping(value = "queryDisputeList", method = RequestMethod.POST)
  DubboResult<PageInfo<DisputesResDTO>> queryDisputeList(@Valid DisputeReqPageListDTO dto);

  /**
   * 统计咨询师咨询数量
   */
  @RequestMapping(value = "disputesCountByStatusAndCounselorId", method = RequestMethod.POST)
  DubboResult<CounselorDisputesCountMapResDTO> disputesCountByStatusAndCounselorId(
      List<String> counselorIds,
      @Valid @NotBlank(message = ConsultancyValidationMessage.ORIGIN_NOT_BLANK) String origin);

  /**
   * 查看纠纷详情
   */
  @RequestMapping(value = "queryDispute", method = RequestMethod.POST)
  DubboResult<DisputesResDTO> queryDispute(
      @Valid @NotNull(message = ConsultancyValidationMessage.DISPUTE_ID_NOT_BLANK) Long disputeId);


  /**
   * 更新纠纷案件ID
   */
  @RequestMapping(value = "updateDisputesLawCaseId", method = RequestMethod.POST)
  DubboResult<Boolean> updateDisputesLawCaseId(@Valid DisputeLawCaseReqDTO dto);

  /**
   * 用户选择咨询师(在基础服务chat中保存聊天关系)
   */
  @RequestMapping(value = "chooseCounselor", method = RequestMethod.POST)
  DubboResult chooseCounselor(@Valid DisputesUserRelationReqDTO dto);

  /**
   * 查询用户选择的咨询师
   */
  @RequestMapping(value = "getUserSelectCounselor", method = RequestMethod.POST)
  DubboResult<String> getUserSelectCounselor(@Valid Long disputeId);

  /**
   * 用户首发聊天信息(保存为待受理状态)
   *
   * @return roomId
   */
  @RequestMapping(value = "changeStatusToWaitingAccept", method = RequestMethod.POST)
  DubboResult changeStatusToWaitingAccept(@Valid DisputesChatWinReqDTO dto);

  /**
   * 咨询是否能受理(未受理的记录,客服发送首个聊天记录时判断)
   */
  @RequestMapping(value = "canAcceptDispute", method = RequestMethod.POST)
  DubboResult<Boolean> canAcceptDispute(@Valid DisputesChatWinReqDTO dto);

  /**
   * 用户首次发消息前需要加入聊天室
   */
  @RequestMapping(value = "customerJoinRoom", method = RequestMethod.POST)
  DubboResult customerJoinRoom(@Valid DisputesChatWinReqDTO dto);

  /**
   * 保存受理咨询关系(客服率先回复用户信息)
   */
  @RequestMapping(value = "customerAcceptDispute", method = RequestMethod.POST)
  DubboResult<Boolean> customerAcceptDispute(@Valid DisputesChatWinReqDTO dto);

  /**
   * 客服转接咨询师
   */
  @RequestMapping(value = "changeToCounselor", method = RequestMethod.POST)
  DubboResult changeToCounselor(@Valid ChangeToCounselorReqDTO dto);

  /**
   * 更新附件(新增或删除,更新json串)
   */
  @RequestMapping(value = "updateDisputesById", method = RequestMethod.POST)
  DubboResult<Boolean> updateDisputesById(@Valid DisputeFileReqDTO dto);

  /**
   * 结束咨询
   */
  @RequestMapping(value = "endDispute", method = RequestMethod.POST)
  DubboResult endDispute(@Valid DisputeRoomMemberReqDTO dto);


  /**
   * 咨询聊天窗口信息
   */
  @RequestMapping(value = "disputesChatWinInfo", method = RequestMethod.POST)
  DubboResult disputesChatWinInfo(@Valid DisputesChatWinReqDTO dto);

  /**
   * 统计用户纠纷数量
   *
   * @param userId 用户Id
   * @return 纠纷数量在data中
   */
  @RequestMapping(value = "countUserDispute", method = RequestMethod.POST)
  DubboResult countUserDispute(
      @Valid @NotBlank(message = ConsultancyValidationMessage.USER_ID_NOT_BLANK) String userId);

  /**
   * 有更新咨询状态,需要设置小红点
   */
  @RequestMapping(value = "showRedRemind", method = RequestMethod.POST)
  DubboResult<Boolean> showRedRemind(
      @Valid @NotBlank(message = ConsultancyValidationMessage.USER_ID_NOT_BLANK) String userId);

  /**
   * 用户或客服首发聊天信息(保存为客服受理状态)(云律只需要为进行中的状态--客服受理)
   *
   * @return roomId
   */
  @RequestMapping(value = "changeStatusToRunning", method = RequestMethod.POST)
  DubboResult<String> changeStatusToRunning(@Valid DisputesChatWinReqDTO dto);


  /**
   * 结束咨询
   */
  @RequestMapping(value = "cloudLawEndDispute", method = RequestMethod.POST)
  DubboResult<Boolean> cloudLawEndDispute(@Valid DisputesChatWinReqDTO dto);


  /**
   * 咨询聊天窗口信息(云律)
   */
  @RequestMapping(value = "cloudLawDisputesChatWinInfo", method = RequestMethod.POST)
  DubboResult<DisputesChatWinResDTO> cloudLawDisputesChatWinInfo(@Valid DisputesChatWinReqDTO dto);

}
