package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.dto.requestdto.CaseListZZReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseListZZResDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "normandy-event", path = "/lawCaseApi", configuration = FeignConfig.class, contextId = "LawCaseApi")
public interface LawCaseApi {

  @RequestMapping(value = "getExistCaseByMediatorIds", method = {RequestMethod.POST})
  DubboResult<String> getExistCaseByMediatorIds(@RequestBody List<Long> mediatorIds);

  @RequestMapping(value = "countByProcDefId", method = {RequestMethod.POST})
  DubboResult<Integer> countByProcDefId(@RequestParam("procDefId") String procDefId);

  /**
   * 根据机构ID查询调解结束的案件
   */
  @RequestMapping(value = "getFinishCaseByOrgId", method = {RequestMethod.POST})
  DubboResult<PageInfo<CaseListZZResDTO>> getFinishCaseByOrgId(@Valid @RequestBody CaseListZZReqDTO request);

}
