package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.requestdto.MediationReallocateReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationSuccessFailReqDTO;
import com.beiming.normandy.event.dto.requestdto.TransferMediationReqDTO;
import com.beiming.normandy.event.dto.responsedto.LawCasePersonResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 调解
 *
 * @author qsh
 * @data 2018年7月3日
 */
@SuppressWarnings("rawtypes")
@Valid
public interface MediationMeetingApi {

  /**
   * 重新分配
   */
  void reallocate(@Valid MediationReallocateReqDTO diationReallocateReqDTO);

  /**
   * 转移调解机构
   */
  void transferMediation(@Valid TransferMediationReqDTO transferMediationReqDTO);

  /**
   * 调解成功
   */
  void mediationSuccess(@Valid MediationSuccessFailReqDTO reqDTO);

  /**
   * 调解失败
   */
  void mediationFail(@Valid MediationSuccessFailReqDTO reqDTO);

  /**
   * 查询案件与人员关系
   */
  DubboResult<ArrayList<LawCasePersonResDTO>> personList(Long caseId, Long userId);

}
