package com.beiming.normandy.event.dto;


import java.io.Serializable;
import com.beiming.framework.message.BaseMessageDto;
import com.beiming.normandy.document.api.enums.RoleTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseExtInfoDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 2039605674084535500L;

  @ApiModelProperty(notes = "bizKey")
  private String bizKey;
  
  @ApiModelProperty(notes = "案件来源")
  private String creatorType; // 法院案件 COURT_TYPE

  @ApiModelProperty(notes = "机构类型")
  private String orgType; // 是否法院案件

  @ApiModelProperty(notes = "机构地区")
  private String orgArea; // 法院地区

  @ApiModelProperty(notes = "机构名称")
  private String orgName; // 法院名称

  @ApiModelProperty(notes = "授权类型")
  private String authorizationType; // 委托 DELEGATE 委派 APPOINT
  
  @ApiModelProperty(notes = "案件Id")
  private Long caseId;
  
  @ApiModelProperty(notes = "操作人ID")
  private Long operatorId;
  @ApiModelProperty(notes = "操作人名称")
  private String operatorName;
  @ApiModelProperty(notes = "操作人案件角色")
  private RoleTypeEnum caseUserType;

}
