package com.beiming.normandy.event.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@ApiModel(description = "案件统计分析请求参数")
@NoArgsConstructor
@AllArgsConstructor
public class EventAnalysisRequestDTO implements Serializable {

  private static final long serialVersionUID = -825344039393382305L;

  @ApiModelProperty(notes = "统计开始日期", example = "2019-03-29 00:00:00")
  private String startTime;

  @ApiModelProperty(notes = "统计结束日期", example = "2019-03-30 00:00:00")
  private String endTime;

  @ApiModelProperty(notes = "机构模糊名称(多个名称以逗号分割)", required = true, example = "红旗区,获嘉县")
  @NotNull(message = "机构模糊名称不能为空")
  private String orgNameStr;
}
