package com.beiming.normandy.event.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 平台概览案件量调解量折线图查询dto
 */
@Data
@ApiModel(description = "平台概览请求参数")
@NoArgsConstructor
@AllArgsConstructor
public class PlatformOverviewReqDTO implements Serializable {

  @ApiModelProperty(notes = "开始日期", required = true, example = "2019-03-29")
  private String startDate;

  @ApiModelProperty(notes = "结束日期", required = true, example = "2019-03-29")
  private String endDate;

  @ApiModelProperty(notes = "机构id", example = "1")
  @NotNull(message = "机构id不能为空")
  private Long orgId;
}
