package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.dto.MediationActualResDTO;
import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 行事历数量
 *
 * @author huaisf
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActCalendarListResDTO implements Serializable {

  private static final long serialVersionUID = -1;

  /**
   * 会议id
   */

  private Long meetingId;

  /**
   * 会议房间id
   */

  private String meetingVideoId;
  /**
   * 案件id
   */

  private Long caseId;

  /**
   * 事件类型
   */

  private String type;

  /**
   * 事件时间
   */

  private Date time;

  /**
   * 卷宗id
   */
  private Long dossierId;
  /**
   * 申请人
   */
  private List<MediationCasePersonnelDTO> applicants;

  /**
   * 被申请人
   */
  private List<MediationCasePersonnelDTO> respondents;

  /**
   * 调解员
   */
  private List<MediationActualResDTO> mediators;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 会议状态
   */
  private String meetingStatus;

  /**
   * 会议结束时间
   */
  private Date endTime;


}
