package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.enums.RegisterOriginEnum;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 协议相关人返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseProtocolAgentPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -4866238168967161027L;


  /**
   * 代理人id
   */
  private String agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;

  /**
   * 代理人固定电话
   */
  private String agentTelephone;

  /**
   * 当事人id
   */
  private Long litigantPersonId;

  /**
   * 代理人注册来源(0: 用户自己注册  1: 平台自动注册)
   */
  private RegisterOriginEnum agentRegisterOrigin;


}
