package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "矛盾纠纷统计总览返回数据")
public class ConflictStatsTotalResponseDTO implements Serializable {

  private static final long serialVersionUID = -7995180898428413372L;

  @ApiModelProperty(notes = "案件受理数", example = "1")
  private Integer caseAcceptCount;

  @ApiModelProperty(notes = "案件受理率", example = "0.12")
  private String caseAcceptRate;

  @ApiModelProperty(notes = "已结案件", example = "1")
  private Integer caseEndCount;

  @ApiModelProperty(notes = "结案率", example = "0.12")
  private String caseEndRate;

  @ApiModelProperty(notes = "调解成功数", example = "1")
  private Integer caseSuccessCount;

  @ApiModelProperty(notes = "案件成功率", example = "0.12")
  private String caseSuccessRate;

  @ApiModelProperty(notes = "收案件")
  private ConflictCaseApplyResponseDTO caseApply;

  @ApiModelProperty(notes = "存案")
  private ConflictCaseExistResponseDTO caseExist;

  @ApiModelProperty(notes = "调解中")
  private ConflictCaseStartResponseDTO caseStart;

  @ApiModelProperty(notes = "已结案件")
  private ConflictCaseEndResponseDTO caseEnd;
}