package com.beiming.normandy.event.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 用户案件视频
 *
 * @author huaisf
 */
@Data
public class UserCaseMeetingListResDTO implements Serializable {


  private static final long serialVersionUID = -1L;

  /**
   * 会议id
   */
  private Long meetingId;
  /**
   * 视频房间id(m.meeting_video_id)
   */
  private String roomId;

  /**
   * 会议类型
   */
  private String meetingType;

  /**
   * 会议状态
   */
  private String meetingStatus;

  /**
   * 会议预约时间
   */
  private Date orderTime;

  /**
   * 会议开始时间
   */
  private Date startTime;

  /**
   * 会议结束时间
   */
  private Date endTime;

  /**
   * 会议名称
   */
  private String meetingName;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 案件状态
   */
  private String caseProgress;


  /**
   * 申请人
   */
  private List<String> applyUserList;


  /**
   * 被申请人
   */
  private List<String> respondentUserList;


}
