package com.beiming.normandy.event.dto.responsedto.dispute;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
public class DisputesResDTO  implements Serializable {


  private static final long serialVersionUID = -6736656745117846758L;

  private Long id;
  /**
   * 纠纷编号
   */
  private String disputeNo;

  /**
   * 纠纷类型
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型名称
   */
  private String disputeTypeName;

  /**
   * 纠纷状态
   */
  private String disputeStatus;

  /**
   * 纠纷状态条
   */
  private List<Map<String, Boolean>> progress;

  /**
   * 纠纷内容
   */
  private String disputeContent;


  /**
   * 完整拼接的地址名称
   */
  private String fullAreasName;

  /**
   * 客服Id
   */
  private String customerId;

  /**
   * 客服
   */
  private String customerName;

  /**
   * 咨询师id
   */
  private String counselorId;

  /**
   * 咨询师
   */
  private String counselorName;

  /**
   * 纠纷诉求
   */
  private String appeal;


  /**
   * 附件（json串的存储格式）
   */
  private String fileJson;


  /**
   * 聊天房间ID
   */
  private String roomId;

  /**
   * 案件ID
   */
  private Long lawCaseId;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建人
   */
  private String createUserName;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 省
   */
  private String provinceCode;
  /**
   * 省
   */
  private String provinceName;
  /**
   * 市
   */
  private String cityCode;
  /**
   * 市
   */
  private String cityName;
  /**
   * 区
   */
  private String areaCode;
  /**
   * 区
   */
  private String areaName;
  /**
   * 街道
   */
  private String streetCode;
  /**
   * 街道
   */
  private String streetName;
  /**
   * 详细地址
   */
  private String detailedAddress;
}