package com.beiming.normandy.event.enums;

import com.beiming.normandy.event.dto.MediationCaseProgressDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 案件进度枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseProgressEnum {
  TRANSFER("已转移"), APPLY("提交申请"), REFUSE("不受理"), WAIT("等待调解"), RETRACT("撤回调解"), START("正在调解"), FAIL(
      "调解失败"), SUCCESS("调解成功"), END("调解结束"),
  
  ABORT("中止");

  private final String name;

  CaseProgressEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 返回包含当前案件状态和案件状态列表
   */
  public static List<MediationCaseProgressDTO> getCaseProgressList(CaseProgressEnum enumObj) {
    List<MediationCaseProgressDTO> lst = new ArrayList<MediationCaseProgressDTO>();
    setCaseProgress(lst, CaseProgressEnum.APPLY, enumObj, 1, false); // 提交申请
    setCaseProgress(lst, CaseProgressEnum.REFUSE, enumObj, 2, true); // 不受理
    setCaseProgress(lst, CaseProgressEnum.WAIT, enumObj, 3, false); // 等待调解
    setCaseProgress(lst, CaseProgressEnum.TRANSFER, enumObj, 4, true); // 已转移
    setCaseProgress(lst, CaseProgressEnum.RETRACT, enumObj, 5, true); // 撤回调解
    setCaseProgress(lst, CaseProgressEnum.START, enumObj, 6, false); // 正在调解
    setCaseProgress(lst, CaseProgressEnum.FAIL, enumObj, 7, true); // 调解失败
    setCaseProgress(lst, CaseProgressEnum.SUCCESS, enumObj, 8, false); // 调解成功
    return lst;
  }

  /**
   * 设置案件进度
   *
   * @param lst 结果列表
   * @param enumX 需要植入的进度状态
   * @param enumY 当前案件进度状态(可NULL)
   * @param order 排序
   * @param hiddenFlag 是否默认隐藏
   */
  private static List<MediationCaseProgressDTO> setCaseProgress(List<MediationCaseProgressDTO> lst,
      CaseProgressEnum enumX, CaseProgressEnum enumY, int order, Boolean hiddenFlag) {
    Boolean flag = false;
    if (enumY != null) {
      flag = enumX.name().equals(enumY.name());
    }
    MediationCaseProgressDTO caseProgressDTO = new MediationCaseProgressDTO(enumX.name(),
        enumX.getName(), (hiddenFlag && flag) ? false : hiddenFlag, flag, order);
    lst.add(caseProgressDTO);
    return lst;
  }
  
  public static Boolean contain(String name) {
    for (CaseProgressEnum caseProgressEnum : CaseProgressEnum.values()) {
      if (caseProgressEnum.name.equals(name)) {
        return true;
      }
    }
    return false;
  }
  
}
