package com.beiming.normandy.event.enums;

/**
 * 案件类型
 *
 * @author huaisf
 */
public enum CaseTypeEnum {

  /**
   * 普通案件
   */
  NORMAL_CASE("普通案件", "普"),

  /**
   * 简易案件
   */
  SIMPLE_CASE("简易案件", "简"),

  MICRO_CASE("小额速调", "速"),
  
  LETTER_CASE("信访", "信访");


  private final String name;

  private final String shortName;

  CaseTypeEnum(String name, String shortName) {
    this.name = name;
    this.shortName = shortName;
  }

  public String getName() {
    return name;
  }

  public String getShortName() {
    return shortName;
  }
  
  public static String getCaseTypeName(String caseTypeCode) {
    String caseTypeName = "";
    for (CaseTypeEnum e : CaseTypeEnum.values()) {
      if (e.name().equals(caseTypeCode)) {
        caseTypeName = e.getName();
      }
    }
    return caseTypeName;
  }

}
