package com.beiming.normandy.event.enums;

import com.beiming.framework.util.StringUtils;

/**
 * @Description: 用户类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum UserTypeEnum {
  NATURAL_PERSON("自然人"), JURIDICAL_PERSON("法人"), UNINCORPORATED_ORGANIZATION("非法人组织");

  private final String name;

  UserTypeEnum(String name) {
    this.name = name;
  }

  public static String toUserType(String userTypeName) {
    if (StringUtils.isNotBlank(userTypeName)) {
      UserTypeEnum[] typeEnums = UserTypeEnum.values();
      for (UserTypeEnum type : typeEnums) {
        if (type.getName().equals(userTypeName.trim())) {
          return type.name();
        }
      }
    }
    return null;
  }

  public String getName() {
    return name;
  }

}
