package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.normandy.event.dto.requestdto.CaseMeetingSaveReqDTO;
import com.beiming.normandy.event.dto.requestdto.SaveTempMediatorReqDTO;
import com.beiming.normandy.event.dto.requestdto.VideoPrivateChatReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.normandy.event.dto.responsedto.CaseMeetingResDTO;
import com.beiming.normandy.event.dto.responsedto.InviteWatchResDTO;
import com.beiming.normandy.event.dto.responsedto.VideoPrivateChatResDTO;
import java.util.ArrayList;
import javax.validation.Valid;


@Valid
public interface CaseMeetingApi {

  /**
   * 保存会议记录
   */
  @SuppressWarnings("rawtypes")
  DubboResult<CaseMeetingResDTO> caseMeetingSave(@Valid CaseMeetingSaveReqDTO reqDTO);

  /**
   * 邀请观摩人
   */
  DubboResult sendViewSms(@Valid CaseMeetingInviteReqDTO reqDTO);

  /**
   * 通过邀请码生成对应信息
   */
  DubboResult<InviteWatchResDTO> inviteWatching(String inviteCode, String userId, String userName);

  /**
   * 查询url路径
   */
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingPersonnel(Long meetingId,
      Long userId, String meetingStatus);

  /**
   * 保存临时调解员
   */
  DubboResult saveTempMediator(@Valid SaveTempMediatorReqDTO reqDTO);

  /**
   * 私聊视频
   *
   * @param videoPrivateChatReqDTO
   * @return
   */
  DubboResult<VideoPrivateChatResDTO> meetingVideoPrivateChat(
      @Valid VideoPrivateChatReqDTO videoPrivateChatReqDTO);
}
