package com.beiming.normandy.event.dto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 案件相关人
 * @Author: caiwei
 * @Date: Created 2018-06-25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationCasePersonnelDTO implements Serializable {

  private static final long serialVersionUID = 5946545033240232723L;

  /**
   * id
   */
  private Long id;

  /**
   * 案件号
   */
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 案件文书id
   */
  private Long documentId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String name;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;


  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 固话
   */
  private String telephone;


  /**
   * 代理人材料
   */
  private List<MediationAgentMaterialDTO> agentMaterials;

  /**
   * 代理人信息
   */
  private List<CaseUserAgentDTO> caseUserAgentList;

  /**
   * 送达地址确认书
   */
  private String docAddress;
  /**
   * 材料id
   */
  private Long lawAttachmentId;

  /**
   * 其它联系电话
   */
  private String contactPhone;
  /**
   * 联系方式类型 字典表中contact_type的子集
   */
  private String contactType;

  /**
   * 信访代理人委托书主键id
   */
  private String proxyId;

  /**
   * 信访代理人委托书id
   */
  private String proxyFileId;

  /**
   * 信访代理人委托书名称
   */
  private String proxyFileName;
  
  /**
   * 其它证件类型
   */
  private String certificateType;

  /**
   * 其它证件号
   */
  private String certificateNo;
  
  /**
   * 扩展json串
   */
  private String extendJson;

  public MediationCasePersonnelDTO(Long userId, String caseUserType, String name, String sex,
      String phone, String idCard, String address, String creditCode,
      Integer order, List<CaseUserAgentDTO> caseUserAgentList) {
    super();
    this.userId = userId;
    this.caseUserType = caseUserType;
    this.name = name;
    this.sex = sex;
    this.phone = phone;
    this.idCard = idCard;
    this.address = address;
    this.creditCode = creditCode;
    this.caseUserAgentList = caseUserAgentList;
    this.userOrder = order;
  }

}
