package com.beiming.normandy.event.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Created by zli on 2019/1/26.
 */
@EqualsAndHashCode(callSuper = true)
@Setter
@Getter
@NoArgsConstructor
@ApiModel(description = "调解用户信息")
public class PersonnelInfoDTO extends UserInfoDTO implements Serializable {

  private static final long serialVersionUID = 1829882280172846264L;
  @ApiModelProperty(notes = "手机号", example = "13000000000")
  private String mobilePhone;

  public PersonnelInfoDTO(Long userId, String userName, String mobilePhone) {
    super(userId, userName);
    this.mobilePhone = mobilePhone;
  }

  @Override
  public String toString() {
    return "PersonnelInfoDTO{"
        + "mobilePhone='" + mobilePhone + '\''
        + "} " + super.toString();
  }
}
