package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

/**
 * @Description: 添加调解室用户请求实体
 * @Author: caiwei
 * @Date: 2019/1/16
 */
@Data
public class AddMediationRoomUserMicroReqDTO implements Serializable {

  /**
   * 调解室id
   */
  private Long mediationRoomId;

  /**
   * 当事人信息列表
   */
  private List<MediationMeetingUseReqDTO> userList;

  /**
   * 法官列表
   */
  private List<MediationMeetingUseReqDTO> mediatorList;


  /**
   * 调解员信息
   */
  private MediationMeetingUserInfoReqDTO mediator;

  /**
   * 登录者id
   */
  private String currentUserId;

  /**
   * 创建者
   */
  private String createUser;


  //是否添加法官
  public boolean isExistMediator() {
    return CollectionUtils.isEmpty(this.mediatorList);
  }

  //是否添加当事人
  public boolean isExistUser() {
    return CollectionUtils.isEmpty(this.userList);
  }

}