package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import com.beiming.normandy.event.dto.CaseOrderConditionDTO;
import com.beiming.normandy.event.dto.MediationListDTO;
import com.beiming.normandy.event.enums.CaseProgressEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数
 *
 * @author DJQ 2018年7月9日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号
  private String disputeTypeCode; // 纠纷类型
  private String disputeNo; // 纠纷编号
  private List<CaseProgressEnum> caseProgress; // 案件进度
  // private String areaCode; // 地区编号
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private String keyWord; // 关键词 编号、姓名、案号
  private String startTime;
  private String endTime;

  private String mediationType; // 调解类型

  private List<Long> orgIds; // 服务机构列表编号
  private String orgAreaCode; // 机构所在地编号
  private Integer orgAreaCodeLevel; // 机构所在地Level

  private List<Long> excludeOrgIds; // 区域管理员排除的机构编号
  /**
   * 创建者类型
   */
  private String creatorType;

  /**
   * DRAFT "草稿", TRASH "作废"
   */
  private String status;

  /**
   * 行政行为code
   */
  private String istrativeActCode;

  /**
   * 行政管理主体code
   */
  private String istrativeManageSubjectCode;

  /**
   * 审批情况查询ApprovalSituationEnum
   */
  private List<String> approvalSituation;

  /**
   * 在案件中身份0当事人，1代理人
   */
  private Integer identityType;

  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 案件归属
   */
  private String caseAttribution;

  /**
   * 是否待分配，YES查询待分配
   */
  private String isWaitAssigned;

  /**
   * 排序规则
   */
  private List<CaseOrderConditionDTO> orderConditionList;
  /**
   * 案件状态类型mediator_case_status|registrar_case_status|manage_case_status
   */
  private String caseStatusType;
  /**
   * 业务状态 字典表中parentCode=caseStatusType remark
   */
  private String bussinessStatus;
  /**
   * 是否诉求上报列表
   */
  private Boolean isUpReport;
  /**
   * 是否机构协助
   */
  private Boolean isOrgHelp;
  private String caseRiskType;
  /**
   * 转换为Mapper查询对象
   */
  public MediationListDTO convertMediationListDTO(List<String> caseStatus, Integer status) {
    MediationListDTO listDTO = new MediationListDTO();
    listDTO.setOrgIds(orgIds);
    listDTO.setOrgAreaCode(orgAreaCode);
    listDTO.setOrgAreaCodeLevel(orgAreaCodeLevel);

    listDTO.setRoleType(roleType); // 用户角色类型： 纠纷登记员 调解人 普通人
    listDTO.setUserId(userId); // 用户ID
    listDTO.setUserType(userType); // 用户类型（申请人，被申请人，调解人）
    listDTO.setOrgId(orgId); // 服务机构编号

    listDTO.setDisputeTypeCode(disputeTypeCode); // 纠纷类型
    listDTO.setDisputeNo(disputeNo); // 纠纷编号
    listDTO.setCaseStatus(caseStatus); // 案件进度
    // listDTO.setareaCode; // 地区编号
    listDTO.setProvCode(provCode); // 省份code
    listDTO.setCityCode(cityCode); // 城市code
    listDTO.setAreaCode(areaCode); // 区code
    listDTO.setStreetCode(streetCode); // 街道code
    listDTO.setKeyWord(keyWord); // 关键词 编号、姓名、案号
    listDTO.setStartTime(startTime);
    listDTO.setEndTime(endTime);
    listDTO.setMediationType(mediationType);
    listDTO.setPageIndex(this.getPageIndex());
    listDTO.setPageSize(this.getPageSize());

    listDTO.setStatus(status);
    listDTO.setExcludeOrgIds(excludeOrgIds);
    listDTO.setCreatorType(creatorType);
    listDTO.setIstrativeActCode(istrativeActCode);
    listDTO.setIstrativeManageSubjectCode(istrativeManageSubjectCode);
    listDTO.setApprovalSituation(approvalSituation);
    listDTO.setIdentityType(identityType);
    listDTO.setCaseType(caseType);
    listDTO.setCaseAttribution(caseAttribution);
    listDTO.setIsWaitAssigned(isWaitAssigned); //TODO 后端没处理
    listDTO.setCaseStatusType(caseStatusType);
    listDTO.setIsUpReport(isUpReport);
    listDTO.setIsOrgHelp(isOrgHelp);
    listDTO.setCaseRiskType(caseRiskType);
    return listDTO;
  }

}
