package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.enums.CaseStatusEnum;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 调解成功和失败公用类
 *
 * @author qsh
 * @data 2018年7月3日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
public class MediationSuccessFailReqDTO implements Serializable {

  @NotNull(message = "案件id不能为空")
  private Long caseId;
  @NotNull(message = "原因类型不能为空")
  private String reasonType; // 原因类型
  private String detailRason; // 详细原因
  private Long userId;
  private String userName;
  private CaseStatusEnum caseStatus;
  private Long actDeButtonId;
  
  public MediationSuccessFailReqDTO(Long caseId, String reasonType, String detailRason, Long userId, String userName) {
    this.caseId = caseId;
    this.reasonType = reasonType;
    this.detailRason = detailRason;
    this.userId = userId;
    this.userName = userName;
  }
}
