package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.enums.MeetingTypeNewEnum;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 新版添加会议dto
 *
 * @author qsh
 * @data 2018年6月22日
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MeetingNewSaveReqDTO extends CommonIdReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * @see MeetingTypeNewEnum
   */
  @NotNull(message = "会议类型不能为空")
  private MeetingTypeNewEnum meetingTypeNewEnum;
  
  private String joinUserId;
  
  @NotNull(message = "预约时间不能为空")
  private Date orderTime;
  
  private String orderAddress;
  
  private Long userId;
  
  private String userName;

  public static CaseMeetingSaveReqDTO converCaseMeetingSaveReqDTO(
      MeetingNewSaveReqDTO meetingNewSaveReqDTO) {
    CaseMeetingSaveReqDTO caseMeetingSaveReqDTO = new CaseMeetingSaveReqDTO();
    caseMeetingSaveReqDTO.setCreateUser(meetingNewSaveReqDTO.getUserName());
    caseMeetingSaveReqDTO.setJoinUserId(meetingNewSaveReqDTO.getJoinUserId());
    caseMeetingSaveReqDTO.setLawCaseId(meetingNewSaveReqDTO.getId());
    caseMeetingSaveReqDTO.setMeetingType(meetingNewSaveReqDTO.getMeetingTypeNewEnum().toString());
    caseMeetingSaveReqDTO.setOrderAddress(meetingNewSaveReqDTO.getOrderAddress());
    caseMeetingSaveReqDTO.setStartTime(meetingNewSaveReqDTO.getOrderTime());
    caseMeetingSaveReqDTO.setOrderTime(meetingNewSaveReqDTO.getOrderTime());
    caseMeetingSaveReqDTO.setUserId(meetingNewSaveReqDTO.getUserId());
    caseMeetingSaveReqDTO.setUserName(meetingNewSaveReqDTO.getUserName());
    caseMeetingSaveReqDTO.setCreateUser(meetingNewSaveReqDTO.getUserName());
    return caseMeetingSaveReqDTO;
  }
}
