package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.dto.MediationCaseProgressDTO;
import com.beiming.normandy.event.dto.PetitionAgentDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 调解信息查看响应参数
 *
 * @author DJQ 2018年6月27日
 */
@Data
@NoArgsConstructor
public class MediationInfoResDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  private String currentCaseUserType; // 当前用户案件内的角色类型

  /**
   * 是否已在法院立案：0为否，1为是
   */
  private Boolean docket; // add by djq 2018-11-29

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private String creatorType; // 案件录入人的身份
  private Long creatorId;
  private Long createTime; // 登记时间
  private Long startTime; // 机构受理时间
  private Long updateTime; // 更新时间
  private String lawCaseStatus; // 案件状态
  private String lawCaseStatusCode; // 案件状态

  private String origin; // 案件来源
  private Long orgId; // 调解机构ID
  private String orgName; // 调解机构
  private String orgAreaCode; // 调解机构区域Code
  private String appeal; // 申请人诉求

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型Code
  private String disputeContent; // 纠纷描述

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  /**
   * 选择性短信发送功能
   */
  private Integer smsOff;

  private List<MediationCasePersonnelDTO> applicants; // 申请人 + agentApplicants 申请人代理人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人 + agentRespondents 被申请人代理人
  private PetitionAgentDTO petitionAgentUser; // 信访代理人
  private List<MediationStaffResDTO> mediators; // 调解员
  private List<MediationCaseProgressDTO> progress; // 案件进度

  /**
   * 记录的状态
   */
  private Integer status;

  /**
   * 机构信息
   */
  private List<MediationInfoSyncOrgsResDTO> syncOrgInfos;

  /**
   * 审批情况，ApprovalSituationEnum
   */
//  private String approvalSituation;
  /**
   * 案件详细状态
   */
  private String detailedStatus;

  /**
   * 行政行为code
   */
//  private String istrativeActCode;

  /**
   * 行政行为名称
   */
//  private String istrativeActName;

  /**
   * 行政管理主体code
   */
//  private String istrativeManageSubjectCode;

  /**
   * 行政管理主体名称
   */
//  private String istrativeManageSubjectName;

  /**
   * 行政管理具体code
   */
//  private String istrativeManageSpecificCode;

  /**
   * 行政管理具体名称
   */
//  private String istrativeManageSpecificName;

  /**
   * 是否行政赔偿0否1是
   */
//  private Integer isCompensation;

  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 调解室房间id
   */
  private Long videoId;

  /**
   * 案件办理信息
   */
  private String handlingInfo;

  /**
   * 法院code
   */
  private String courtCode;

  /**
   * 法院名字
   */
  private String courtName;

  private String syncThird;

  private Date registrationTime;
  /**
   * 审核员
   */
  private String auditorName;
  /**
   * 标的金额
   */
  private BigDecimal caseAmount;

  private String procDefId;

  private String procInstId;

  private String formId;

  private List<String> eventList;
  
  private String extendJson;

  /**
   * 当前节点角色
   */
  private String currentNodeRole;
  
  private Date handUpTime;

  /**
   * 纠纷难易程度code
   */
  private String difficultyDisputeCode;
  /**
   * 纠纷难易程度名称
   */
  private String difficultyDisputeName;
  
  /**
   * 二维码
   */
  private String qrCodeImage;
  /**
   * 是否上链
   */
  private Boolean isUpBlockChain;
  
  private String caseRiskType;

}
