package com.beiming.normandy.event.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public enum FileTypeBigEnum {
  DOCUMENT("文档"), PHOTO("图片"), AUDIO("音频"), ONLINE_TEXT("在线文本");

  private String name;

  FileTypeBigEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static JSONArray toJsonArray() {
    JSONArray array = new JSONArray();
    JSONObject object = null;
    for (FileTypeBigEnum e : FileTypeBigEnum.values()) {
      object = new JSONObject();
      object.put("code", e.name());
      object.put("name", e.getName());
      array.add(object);
    }
    return array;
  }

  public static void main(String[] args) {
    System.err.println(FileTypeBigEnum.toJsonArray());
  }
}
