package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.constant.RefereeValidateMessage;
import com.beiming.normandy.event.dto.LawCaseInfoDTO;
import com.beiming.normandy.event.dto.requestdto.CaseCountReqDTO;
import com.beiming.normandy.event.dto.requestdto.CaseListZZReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseCountCountResDTO;
import com.beiming.normandy.event.dto.responsedto.CaseListZZResDTO;
import com.beiming.normandy.event.dto.responsedto.LawCaseInfoResDTO;
import com.beiming.normandy.event.dto.responsedto.MediationCountResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "normandy-event", path = "/lawCaseApi", configuration = FeignConfig.class, contextId = "LawCaseApi")
public interface LawCaseApi {

  @RequestMapping(value = "getExistCaseByMediatorIds", method = {RequestMethod.POST})
  DubboResult<String> getExistCaseByMediatorIds(@RequestBody List<Long> mediatorIds);

  @RequestMapping(value = "getDetailById", method = {RequestMethod.POST})
  DubboResult<LawCaseInfoDTO> getDetailById(Long id);

  @RequestMapping(value = "countByProcDefId", method = {RequestMethod.POST})
  DubboResult<Integer> countByProcDefId(@RequestParam("procDefId") String procDefId);

  /**
   * 根据机构ID查询调解结束的案件
   */
  @RequestMapping(value = "getFinishCaseByOrgId", method = {RequestMethod.POST})
  DubboResult<PageInfo<CaseListZZResDTO>> getFinishCaseByOrgId(
      @Valid @RequestBody CaseListZZReqDTO request);

  /**
   * 根据useridList返回调解数量
   */
  @RequestMapping(value = "/countMediatorLawCaseNum", method = RequestMethod.POST)
  DubboResult<MediationCountResDTO> countMediatorLawCaseNum(
      @RequestParam(name = "userIds") ArrayList<Long> userIds);

  /**
   * 查询已受理案件数
   */
  @RequestMapping(value = "/getAcceptedCaseNumber", method = RequestMethod.POST)
  DubboResult<Integer> getAcceptedCaseNumber(@RequestParam("cacheFlag") Boolean cacheFlag);

  /**
   * 查询已办结案件数
   */
  @RequestMapping(value = "/getEndCaseNumber", method = RequestMethod.POST)
  DubboResult<Integer> getEndCaseNumber(@RequestParam("cacheFlag") Boolean cacheFlag);


  /**
   * 根据调解员id查询 某办理状态的案件
   */
  @RequestMapping(value = "/getCaseCountByCaseProgress", method = RequestMethod.POST)
  DubboResult<CaseCountCountResDTO> getCaseCountByCaseProgress(
      @Valid @RequestBody CaseCountReqDTO reqDTO);

  /**
   * 更新会议结束时间
   */
  @RequestMapping(value = "/updateCaseMeetingEndTime", method = RequestMethod.POST)
  DubboResult updateCaseMeetingEndTime(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL) @RequestParam(
          name = "roomId") String roomId);

  /**
   * 网关调更 开始时间更新
   */
  @RequestMapping(value = "/updateMeetingStartTime", method = RequestMethod.POST)
  DubboResult<Boolean> updateMeetingStartTime(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_MEET_ID_NULL) @RequestParam(
          name = "roomId") String roomId);

  /**
   * 查询某用户（申请人）的所有案件信息
   */
  @RequestMapping(value = "/getCaseInfoByUserId", method = RequestMethod.POST)
  DubboResult<ArrayList<LawCaseInfoResDTO>> getCaseInfoByUserId(@RequestParam("userId") Long userId);

  /**
   * 查询案件成功率(首页)
   */
  @RequestMapping(value = "/getSuccessRate", method = RequestMethod.POST)
  DubboResult<String> getSuccessRate(@RequestParam("cacheFlag") Boolean cacheFlag);
}
