package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.MediationCaseBaseDTO;
import com.beiming.normandy.event.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.normandy.event.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationCaseReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseResDTO;
import com.beiming.normandy.event.dto.responsedto.SaveCaseUserResDTO;
import javax.validation.Valid;

/**
 * @Description: 调解案件api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
public interface MediationCaseApi {

  /**
   * 根据案件id查询案件信息
   */
  DubboResult<CaseResDTO> getMediationCaseInfoById(Long caseId);

  /**
   * 插入案件
   */
  DubboResult<Long> insertMediationCase(@Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 新增或者修改案件人
   */
  DubboResult<SaveCaseUserResDTO> saveOrEditCaseUser(@Valid MediationCaseUserReqDTO mediationCaseUserReqDTO);

  /**
   * 删除案件人
   */
  DubboResult deleteCasePersonnel(@Valid DeleteCasePersonnelReqDTO reqDTO);

  /**
   * 编辑案件纠纷信息
   */
  DubboResult editCaseDisputeInfo(EditCaseDisputeReqDTO dto);

  /**
   * 根据案件id查询案件基本信息
   */
  DubboResult<MediationCaseBaseDTO> getMediation(Long caseId);

  /**
   * 更新案件调解室id
   *
   * @param caseId
   * @param videoId
   * @return
   */
  DubboResult updateVideoId(@Valid Long caseId, Long videoId);
  
}
