package com.beiming.normandy.event.constant;

/**
 * @Description: 常量类
 * @Author: caiwei
 * @Date: 2020/6/28
 */
public class EventConst {

  // 接口url请求前缀
  public static final String URL_PREFIX = "/event";

  /**
   * 案件来源-华宇
   */
  public static final String CASE_TYPE_HUAYU = "HUAYU";

  /**
   * 案件来源-道交推送过来的
   */
  public static final String CASE_TYPE_DAOJIAO = "DAOJIAO";

  /**
   * <pre>
   * 1.微庭审当事人不参与案件时,手机号为1111
   * 2.被申请人没有手机号时暂时用4个1替代(华宇引调来的案件)
   */
  public static final String ABSENT_USER_PHONE = "1111";

  /**
   * 信用代码正则
   */
  public static final String REGEX_CREDIT_CODE = "^(?:(?![IOZSV])[\\dA-Z]){2}\\d{6}(?:(?![IOZSV])[\\dA-Z]){10}$|(^\\d{15})$";

  /**
   * 无撤回案件权限
   */
  public static final int NOT_CANCEL_CASE_AUTHORITY = 0;

  /**
   * 当事人撤回案件
   */
  public static final int LITIGANT_CANCEL_CASE = 1;

  /**
   * 调解员撤回案件
   */
  public static final int MEDIATOR_CANCEL_CASE = 2;

  /**
   * 发送短信
   */
  public static final String SEND_MESSAGE_YES = "1";

  /**
   * 不发短信
   */
  public static final String SEND_MESSAGE_NO = "0";

  /**
   * 默认版本号
   */
  public static final Integer DEFAULT_VERSION = 0;

  /**
   * 会议id
   */
  public static final String MEETING_ID = "meetingId";

  /**
   * 房间id
   */
  public static final String ROOM_ID = "roomId";

  /**
   * 会议结束时间
   */
  public static final String END_TIME = "endTime";

  /**
   * 会议开始时间
   */
  public static final String ORDER_TIME = "orderTime";

  /**
   * 调解材料数据字典父级code
   */
  public static final String MEDIATE_MATERIAL_TYPE = "MEDIATE_MATERIAL_TYPE";

  public static final String DOT = ".";

  /**
   * 预览前缀
   */
  public static final String FILE_PREFIX = "basic/file/preview/";
}