package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.dto.FileDTO;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 生成电子卷宗之前上传多个文件
 *
 * @author chenjt
 * @data 2018年8月22日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BatchFilesReqDTO implements Serializable {

  private static final long serialVersionUID = 4772247537899586575L;
  @NotNull(message = "案件id不能为空")
  private Long caseId;

  @NotNull(message = "文件不能为空")
  @Size(message = "文件不允许为空", min = 1)
  private List<FileDTO> files;

  @NotNull(message = "sign不能为空")
  private String sign;
  @NotNull(message = "用户id不能为空")
  private Long userId;
  private String categoryMiddle;
  private String categorySmall;
  private String userName;
  private String objectType; // 类型
  private String categoryBig;
  private String previewUrl;
  private Long meetingId; // 会议id
  private String fileType; // 材料类型
  /**
   * 证明对象
   */
  private String objectProof;
  private String remark; //备注
  /**
   * 来源
   */
  private String origin;
}
