package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.dto.responsedto.CaseMeetingResDTO;
import com.beiming.normandy.event.enums.CaseCirculationMessageEnum;
import com.beiming.normandy.event.enums.MeetingTypeNewEnum;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class CaseCirculationMessageReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;


  /**
   * 案件id
   */
  private Long caseId;
  /**
   * 业务id
   */
  private Long objectId;
  /**
   * 业务类型
   */
  private CaseCirculationMessageEnum objectType;

  /**
   * 会议类型
   */
  private MeetingTypeNewEnum meetingTypeNewEnum;


  /**
   * 预约时间
   */
  private Date orderTime;

  /**
   * 会议房间id
   */
  private String meetingVidoId;
  /**
   * 用户id
   */
  private String userId;

  private String userName;

  /**
   * 扩展字段
   */
  private String exContent;

  /**
   * 普通消息
   */
  public CaseCirculationMessageReqDTO(Long caseId, CaseCirculationMessageEnum objectType) {
    this.caseId = caseId;
    this.objectType = objectType;
  }

  /**
   * 增加扩展字段 普通消息
   */
  public CaseCirculationMessageReqDTO(Long caseId, CaseCirculationMessageEnum objectType,
      String exContent) {
    this.caseId = caseId;
    this.objectType = objectType;
    this.exContent = exContent;
  }

  /**
   * 会议消息
   */
  public CaseCirculationMessageReqDTO(Long caseId, CaseCirculationMessageEnum objectType,
      CaseMeetingResDTO dto, MeetingTypeNewEnum meetingTypeNewEnum) {
    this.meetingTypeNewEnum = meetingTypeNewEnum;
    this.orderTime = new Date(dto.getOrderTime());
    this.caseId = caseId;
    this.objectType = objectType;
    this.meetingVidoId = dto.getMeetingVideoId();
    this.objectId = dto.getId();
  }

}
