package com.beiming.normandy.event.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.normandy.event.enums.CaseProgressEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: liufeng
 * @Date: 2021/3/23
 * @desc 中证机构案件列表获取
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseListZZReqDTO extends PageQuery implements Serializable {

  /**
   * 开始时间
   */
  private Date beginTime;

  /**
   * 结束时间
   */
  private Date endTime;

  /**
   * 机构ID
   */
  @NotBlank(message = "机构ID不能为空")
  private String orgId;

  /**
   * 案件状态
   */
  private List<CaseProgressEnum> caseStatus;

}
