package com.beiming.normandy.event.dto.requestdto.blockchain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * @ClassName BlockChainRequestDTO
 * @Description
 * @Author xiet
 * @DATE 2021/7/28 5:13 PM
 * @VERSION 1.0
 **/
@Data
public class BlockChainRequestDTO implements Serializable {

  private BlockChain blockChain;

  private String functionName;

  private List<String> params;

  private String sign;


  public static BlockChainRequestDTO buildInsertBlockChainRequestDTO(String param,
      List<String> needParams) {
    BlockChain blockChainDTO = new BlockChain();
    blockChainDTO.setChainCodeName("letters");
    blockChainDTO.setChaincodeVersion("1.0");
    blockChainDTO.setChannelId("mychannel");
    BlockChainRequestDTO blockChainRequestDTO = new BlockChainRequestDTO();
    blockChainRequestDTO.setBlockChain(blockChainDTO);
    blockChainRequestDTO.setFunctionName("VisitInfoSend");
    List<String> params = new ArrayList<>();
    while (needParams.size() < 18) { //needParams参数必须18个
      needParams.add("");
    }
    /*List<String> needParams = Lists.newArrayList("test666", "test777",
        "test555",
        "test444",
        "test222",
        "test333",
        "test",
        "test",
        "0",
        "test",
        "test",
        "test",
        "0",
        "0",
        "4d298c48-8d8f-4ca5-8745-7e131b6ee570",
        "1",
        "73f2b8f6-f138-4b75-b0af-fd0df703fde4",
        "");*/
    params.add(param);
    params.addAll(needParams);

    blockChainRequestDTO.setParams(params);
    blockChainRequestDTO.setSign(
        "IEHAiciJvU3csIyRy7ivwUIjIskrFr3jH4tUxS8y8+3G6t2DrKYMnI+IvpnnU3kKQ5/vR0nd/c+1Yjc1H03j913TR45odotLmxJ/QoBs95wfOVqBrMzFJVsJzG3Ja9/waSjU45WWaiHWVPbSRWDN2WmS/xs0zb+wxKriKqfgSKU=");
    return blockChainRequestDTO;
  }

  public BlockChainRequestDTO() {
    
  }
}
