package com.beiming.normandy.event.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * @Description: 案件状态枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseStatusEnum {
  REFUSE_ACCEPTANCE("不受理", CaseProgressEnum.REFUSE),
  APPLY_SUBMIT("案件登记成功", CaseProgressEnum.APPLY),
  WAIT_ALLOCATED_TO_MEDIATION_AGENCY("已分配给调解机构", CaseProgressEnum.WAIT),
  WAIT_TRANSFER_TO_MEDIATION_AGENCY("转移调解机构", CaseProgressEnum.WAIT),
  WAIT_ASSIGNED_TO_MEDIATOR("已分配给调解员", CaseProgressEnum.WAIT),
  WAIT_AGENCY_RETRACT_MEDIATOR("机构管理员撤回调解员", CaseProgressEnum.WAIT),
  WAIT_MEDIATOR_REALLOCATE("纠纷等待分配", CaseProgressEnum.WAIT),
  //  WAIT_UNABLE_MEDIATION("无法调解"),
  WAIT_MEDIATOR_CHECK_CASE_DATA("调解员查看案件资料", CaseProgressEnum.WAIT),
  WAIT_CASE_ACCEPTANCE("案件受理", CaseProgressEnum.WAIT),
  WAIT_MEDIATION_DOC_ADDRESS_BOOK("送达地址确认书", CaseProgressEnum.WAIT),
  START_ORDER_MEDIATION_TIME("已预约调解时间", CaseProgressEnum.START),
  // 调查暂时取消
  START_ORDER_VIDEO_RESEARCH("已经预约视频调查", CaseProgressEnum.START),
  START_INVITE_VIDEO_RESEARCH("调解员邀请观摩人", CaseProgressEnum.START),
  START_VIDEO_MEDIATION_START("视频调解或调查开始", CaseProgressEnum.START),
  START_VIDEO_MEDIATION_END("视频调解或调查结束", CaseProgressEnum.START),
  START_ORDER_UNDER_LINE_MEETING_TIME("预约线下会议时间", CaseProgressEnum.START),
  START_ORDER_UNDER_LINE_OTHER_MEETING_TIME("预约线下其他会议时间", CaseProgressEnum.START),
  START_ORDER_CONSULT_TIME("预约视频会商时间", CaseProgressEnum.START),

  // 调解协议书
  START_MEDIATION_BOOK_DOCUMENT_SEND("调解员发送调解协议书", CaseProgressEnum.START),
  START_MEDIATION_BOOK_DOCUMENT_REFUSE("一方拒绝了调解协议", CaseProgressEnum.START),
  START_MEDIATION_BOOK_DOCUMENT_SIGNATURE("一方确认了调解协议", CaseProgressEnum.START),
  START_MEDIATION_BOOK_DOCUMENT_SIGNATURE_FAIL("调解协议确认失败", CaseProgressEnum.START),
  START_MEDIATION_BOOK_DOCUMENT_SIGNATURE_SUCCESS("调解协议确认成功", CaseProgressEnum.START),
  START_MEDIATION_BOOK_DOCUMENT_CANCEL("调解协议作废", CaseProgressEnum.START),

  // 无争议事实
  START_UNDISPUTED_FACT_DOCUMENT_SEND("调解员发送了无争议事实", CaseProgressEnum.START),
  START_UNDISPUTED_FACT_DOCUMENT_SIGNATURE("确认了无争议事实", CaseProgressEnum.START),
  START_UNDISPUTED_FACT_DOCUMENT_REFUSE("拒绝了无争议事实", CaseProgressEnum.START),
  START_UNDISPUTED_FACT_DOCUMENT_SIGNATURE_SUCCESS("无争议事实确认成功", CaseProgressEnum.START),
  START_UNDISPUTED_FACT_DOCUMENT_SIGNATURE_FAIL("无争议事实确认失败", CaseProgressEnum.START),
  START_UNDISPUTED_FACT_DOCUMENT_CANCEL("无争议事实作废", CaseProgressEnum.START),

  // 无异议调解方案
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_SEND("发送了无异议调解方案", CaseProgressEnum.START),
  START_COMMITMENT_BOOK_DOCUMENT_SIGNATURE("一方确认承诺书", CaseProgressEnum.START),
  START_COMMITMENT_BOOK_DOCUMENT_REFUSE("一方拒绝承诺书", CaseProgressEnum.START),
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_SIGNATURE("一方同意了调解方案", CaseProgressEnum.START),
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_REFUSE("一方拒绝了调解方案并且提出了异议书", CaseProgressEnum.START),
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_SIGNATURE_SUCCESS("无异议调解方案确认成功", CaseProgressEnum.START),
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_SIGNATURE_FAIL("无异议调解方案确认失败", CaseProgressEnum.START),
  START_NO_DISSENT_MEDIATION_SCHEME_DOCUMENT_CANCEL("无异议调解方案作废", CaseProgressEnum.START),

  // 笔录
  START_MEDIATION_RECORD_DOCUMENT_SEND("调解员发送调解笔录", CaseProgressEnum.START),
  START_MEDIATION_RECORD_DOCUMENT_REFUSE("一方拒绝了调解笔录", CaseProgressEnum.START),
  START_MEDIATION_RECORD_DOCUMENT_SIGNATURE("一方同意了调解笔录", CaseProgressEnum.START),
  START_MEDIATION_RECORD_DOCUMENT_CANCEL("调解笔录作废", CaseProgressEnum.START),
  START_INQUIRE_RECORD_DOCUMENT_SEND("调解员发送调查笔录", CaseProgressEnum.START),
  START_INQUIRE_RECORD_DOCUMENT_REFUSE("一方拒绝了调查笔录", CaseProgressEnum.START),
  START_INQUIRE_RECORD_DOCUMENT_SIGNATURE("一方同意了调查笔录", CaseProgressEnum.START),
  START_INQUIRE_RECORD_DOCUMENT_CANCEL("调查笔录作废", CaseProgressEnum.START),

  // 调解申请书
  START_MEDIATION_APPLY_BOOK_DOCUMENT_SEND("调解员发送调解申请书", CaseProgressEnum.START),
  START_MEDIATION_APPLY_BOOK_DOCUMENT_REFUSE("一方拒绝了调解申请书", CaseProgressEnum.START),
  START_MEDIATION_APPLY_BOOK_DOCUMENT_SIGNATURE("一方确认了调解申请书", CaseProgressEnum.START),
  START_MEDIATION_APPLY_BOOK_CONFIRM_DOCUMENT_SIGNATURE_SUCCESS("调解申请书确认成功", CaseProgressEnum.START),
  START_MEDIATION_APPLY_BOOK_DOCUMENT_SIGNATURE_FAIL("调解申请书确认失败", CaseProgressEnum.START),
  START_MEDIATION_APPLY_BOOK_DOCUMENT_CANCEL("调解申请书作废", CaseProgressEnum.START),

  //授权委托书
  START_AUTHORIZE_PROXY_DOCUMENT_SEND("调解员发送授权委托书", CaseProgressEnum.START),
  START_AUTHORIZE_PROXY_DOCUMENT_REFUSE("当事人拒绝了授权委托书", CaseProgressEnum.START),
  START_AUTHORIZE_PROXY_DOCUMENT_SIGNATURE("当事人同意了授权委托书", CaseProgressEnum.START),
  START_AUTHORIZE_PROXY_DOCUMENT_CANCEL("授权委托书作废", CaseProgressEnum.START),

  // 权利义务告知书
  START_RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK_DOCUMENT_SEND("调解员发送了当事人权利义务告知书", CaseProgressEnum.START),
  START_RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK_DOCUMENT_SIGNATURE("一方确认了权利义务告知书", CaseProgressEnum.START),
  START_RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK_DOCUMENT_SIGNATURE_SUCCESS("权利义务告知书确认成功", CaseProgressEnum.START),
  START_RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK_DOCUMENT_CANCEL("权利义务告知书作废", CaseProgressEnum.START),

  // 调解告知书
  START_DELEGATE_MEDIATION_NOTICE_BOOK_DOCUMENT_SEND("调解员发送委派调解告知书", CaseProgressEnum.START),
  START_SINGLE_DELEGATE_MEDIATION_NOTICE_BOOK_DOCUMENT_SEND("调解员单个发送委派调解告知书", CaseProgressEnum.START),
  START_DELEGATE_MEDIATION_NOTICE_BOOK_DOCUMENT_REFUSE("一方拒绝了委派调解告知书", CaseProgressEnum.START),
  START_DELEGATE_MEDIATION_NOTICE_BOOK_DOCUMENT_SIGNATURE("一方确认了委派调解告知书", CaseProgressEnum.START),
  START_DELEGATE_MEDIATION_NOTICE_BOOK_DOCUMENT_CANCEL("委派调解告知书作废", CaseProgressEnum.START),
  START_AUTHORIZE_MEDIATION_NOTICE_BOOK_DOCUMENT_SEND("调解员发送委托调解告知书", CaseProgressEnum.START),
  START_SINGLE_AUTHORIZE_MEDIATION_NOTICE_BOOK_DOCUMENT_SEND("调解员单个发送委托调解告知书", CaseProgressEnum.START),
  START_AUTHORIZE_MEDIATION_NOTICE_BOOK_DOCUMENT_REFUSE("一方拒绝了委托调解告知书", CaseProgressEnum.START),
  START_AUTHORIZE_MEDIATION_NOTICE_BOOK_DOCUMENT_SIGNATURE("一方确认了委托调解告知书", CaseProgressEnum.START),
  START_AUTHORIZE_MEDIATION_NOTICE_BOOK_DOCUMENT_CANCEL("委托调解告知书作废", CaseProgressEnum.START),
  START_SEND_ADDRESS_CONFIRM_BOOK_DOCUMENT_SEND("调解员发送送达地址确认书", CaseProgressEnum.START),
  START_SINGLE_SEND_ADDRESS_CONFIRM_BOOK_DOCUMENT_SEND("调解员单个发送送达地址确认书", CaseProgressEnum.START),
  START_SEND_ADDRESS_CONFIRM_BOOK_DOCUMENT_SIGNATURE("一方确认了送达地址确认书", CaseProgressEnum.START),
  START_SEND_ADDRESS_CONFIRM_BOOK_CONFIRM_SUCCESS("调解员确认了送达地址确认书", CaseProgressEnum.START),
  START_SEND_ADDRESS_CONFIRM_BOOK_DOCUMENT_CANCEL("送达地址确认书作废", CaseProgressEnum.START),
  START_SINGLE_MEDIATION_BOOK_DOCUMENT_CANCEL("调解协议书作废", CaseProgressEnum.START),

  // 司法确认申请书
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_SEND("调解员发送了申请司法确认申请书", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_SIGNATURE("确认了申请司法确认申请书", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_REFUSE("拒绝了申请司法确认申请书", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_SIGNATURE_SUCCESS("申请司法确认申请确认成功", CaseProgressEnum.SUCCESS), //可以去申请司法确认
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_SIGNATURE_FAIL("申请司法确认申请确认失败", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_BOOK_DOCUMENT_CANCEL("申请司法确认作废", CaseProgressEnum.SUCCESS),

  // 申请司法确认
  SUCCESS_JUDICIAL_CONFIRM_APPLY("已申请司法确认", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_INIT("司法确认待确认", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_CALLBACK("司法确认驳回申请", CaseProgressEnum.SUCCESS),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_VALID("司法确认确认有效", CaseProgressEnum.SUCCESS),

  START_END_MEDIATION_REPORT_DOCUMENT_SEND("调解员发送了终结调解报告", CaseProgressEnum.SUCCESS),
  START_END_MEDIATION_REPORT_DOCUMENT_CANCEL("终结调解报告作废", CaseProgressEnum.SUCCESS),


  //文书取消
  START_MEDIATION_CANCEL("文书取消", CaseProgressEnum.START),
  // ### 文书类状态 END
  // 会议内容修改
  START_MEETING_CONTENT("会议内容修改", CaseProgressEnum.START),
  RETRACT_CANCEL_CASE("撤回调解案件", CaseProgressEnum.RETRACT),
  RETRACT_CANCEL_CASE_MEDIATOR("调解员撤回调解案件", CaseProgressEnum.RETRACT),
  FAIL_MEDIATION("调解失败", CaseProgressEnum.FAIL), //可以去申请诉讼
  FAIL_EXCEED_MEDIATION_TERM("超过调解期限", CaseProgressEnum.FAIL),
  FAIL_SUIT_APPLY("已申请诉讼", CaseProgressEnum.FAIL), //是 申请诉讼了  保存
  FAIL_SUIT_APPLY_SEND("已发送诉讼", CaseProgressEnum.FAIL), //是已经申请诉讼了  发送
  
  ABORT_MEDIATION("中止调解", CaseProgressEnum.ABORT),
  
  SUCCESS_MEDIATION("调解成功", CaseProgressEnum.SUCCESS), //达成调解协议书
  SUCCESS_MEDIATION_OTHERS("调解成功-其他", CaseProgressEnum.SUCCESS), // 其他
  SUCCESS_MEDIATION_APPLICANT_RETRACT("调解成功-申请人撤回起诉", CaseProgressEnum.SUCCESS), //申请人撤回

  SUCCESS_AGREEMENT_BOOK_INIT("已保存出具调解书", CaseProgressEnum.SUCCESS), //使用
  SUCCESS_AGREEMENT_BOOK_APPLY("已申请出具调解书", CaseProgressEnum.SUCCESS), //未使用
  
  START_MEDIATION_LOOK_CASE("调解员查看纠纷详情", CaseProgressEnum.START), // 调解员查看案件资料
  START_MEDIATION_DEFERRED("调解员延长调解期限", CaseProgressEnum.START),
  START_MEDIATION_UPCOMING_DUE_NOTICE("调解期限倒计时通知", CaseProgressEnum.START),

  START_INVITE_MEDIATOR_HELP("邀请协助调解员", CaseProgressEnum.START),
  START_CANCEL_MEDIATOR_HELP("取消邀请协助调解员", CaseProgressEnum.START),
  START_INVITE_MEDIATOR_HELP_AGAIN("重新邀请协助调解员", CaseProgressEnum.START),
  START_INVITE_MEDIATOR_HELP_TEMPORARY("邀请临时调解员", CaseProgressEnum.START),

  //德清案件审批
  START_SUCCESS_APPROVAL("调解成功提交审批", CaseProgressEnum.START),
  START_FAIL_APPROVAL("调解失败提交审批", CaseProgressEnum.START),
  START_SUCCESS_CASE_APPROVAL_REJECT("调解成功案件审批驳回", CaseProgressEnum.START),
  START_FAIL_CASE_APPROVAL_REJECT("调解失败案件审批驳回", CaseProgressEnum.START),

  //调解期限
  START_POSTPONE_APPLY("申请延期", CaseProgressEnum.START),
  START_POSTPONE_ONE_CONFIRM("延期申请有人同意", CaseProgressEnum.START),
  START_POSTPONE_CONFIRM_SUCCESS("延期申请成功", CaseProgressEnum.START),
  START_POSTPONE_UNDER_LINE_CONFIRM_SUCCESS("延期申请成功", CaseProgressEnum.START),
  START_POSTPONE_CONFIRM_FAIL("延期申请失败", CaseProgressEnum.START),
  START_POSTPONE_CONFIRM_EXCEED("延期申请确认超期", CaseProgressEnum.START),
  START_POSTPONE_APPLY_AUTO("超期自动延期", CaseProgressEnum.START),

  START_SET_DIFFICULTY("设置疑难程度", CaseProgressEnum.START),
  
  SUCCESS_MEDIATION_BOOK_APPLY("出具调解书", CaseProgressEnum.SUCCESS),

  START_SINGLE_RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK_DOCUMENT_CANCEL("权利义务告知书取消", CaseProgressEnum.START),
  
  HAND_UP_CASE_APPLY("申请挂起", CaseProgressEnum.START),
  HAND_UP_CASE("挂起", CaseProgressEnum.START),
  HAND_UP_CASE_FAIL("挂起失败", CaseProgressEnum.START),
  ACTIVATE_CASE("重启", CaseProgressEnum.START),
  ACTIVATE_CASE_APPLY("申请重启", CaseProgressEnum.START),
  ACTIVATE_CASE_FAIL("重启失败", CaseProgressEnum.START),
  ACHIEVE_FILES("审核卷宗成功", CaseProgressEnum.END),
  WAIT_TO_CONFIRM_MEDIATOR("分配调解员待确认", CaseProgressEnum.WAIT),
  WAIT_CONFIRM_UNAGREE_MEDIATOR("反对分配", CaseProgressEnum.WAIT),
  WAIT_CONFIRM_AGREE_MEDIATOR("同意分配", CaseProgressEnum.WAIT),
  WAIT_CONFIRM_WITHOUT_OPINION("到期未选择确认调解员", CaseProgressEnum.WAIT),

  WAIT_VOTE_SUCCESS("合意成功", CaseProgressEnum.WAIT),
  WAIT_VOTE_FAIL("合意失败", CaseProgressEnum.WAIT),
  WAIT_CHOOSE_MEDIATOR("选择调解员", CaseProgressEnum.WAIT),
  WAIT_RECOMMEND_MEDIATOR("推荐调解员", CaseProgressEnum.WAIT),
  
  AVOID_MEDIATOR_APPLY("申请回避调解员", CaseProgressEnum.START),
  AVOID_MEDIATOR_SUCCESS("回避调解员成功", CaseProgressEnum.START),
  AVOID_MEDIATOR_FAIL("回避调解员失败", CaseProgressEnum.START),
  
  CORRECTION_CASE_SEND_BACK_APPLY("退回案件申请", CaseProgressEnum.START),
  CORRECTION_CASE_SEND_BACK_SUCCESS("退回案件成功", CaseProgressEnum.START),
  CORRECTION_CASE_SEND_BACK_FAIL("退回案件失败", CaseProgressEnum.START),
  CORRECTION_CASE_SUBMIT("补正提交", CaseProgressEnum.START),
  CORRECTION_CASE_SUBMIT_SUCCESS("补正提交成功", CaseProgressEnum.START),
  
  
  WAIT_ASSIGN_STAFF("分配工作人员", CaseProgressEnum.WAIT),
  
  // 征询
  WAIT_START_COMMON_CONSULTATION("发起普通征询", CaseProgressEnum.WAIT),
  WAIT_START_SMALL_CONSULTATION("发起小额征询", CaseProgressEnum.WAIT),
  
  WAIT_AGREE_COMMON_CONSULTATION("同意普通征询", CaseProgressEnum.WAIT),
  WAIT_REFUSE_COMMON_CONSULTATION("拒绝普通征询", CaseProgressEnum.WAIT),
  WAIT_AGREE_SMALL_CONSULTATION("同意小额征询", CaseProgressEnum.WAIT),
  WAIT_REFUSE_SMALL_CONSULTATION("同意小额征询", CaseProgressEnum.WAIT),
  
  WAIT_IMPORT_COMMON_CONSULTATION("普通征询录入", CaseProgressEnum.WAIT),
  WAIT_IMPORT_SMALL_CONSULTATION("小额征询录入", CaseProgressEnum.WAIT),
  
  END_COMPLETE("已办结", CaseProgressEnum.END),
  REPLY("已答复", CaseProgressEnum.WAIT),
  ;

  private final String name;
  
  public CaseProgressEnum getCaseProgress() {
    return caseProgress;
  }
  
  private final CaseProgressEnum caseProgress;

  CaseStatusEnum(String name, CaseProgressEnum caseProgress) {
    this.name = name;
    this.caseProgress = caseProgress;
  }

  /**
   * 根据状态前缀获取进度枚举值
   */
  public static CaseProgressEnum getCaseProgressEnum(CaseStatusEnum caseStatusEnum) {
    return caseStatusEnum.getCaseProgress();
  }

  /**
   * 根据进度查询状态
   */
  public static List<CaseStatusEnum> queryCaseStatusEnumLst(CaseProgressEnum caseProgressEnum) {
    List<CaseStatusEnum> result = new ArrayList<CaseStatusEnum>();

    EnumSet<CaseStatusEnum> caseStatusEnumSet = EnumSet.allOf(CaseStatusEnum.class);
    for (CaseStatusEnum tmp : caseStatusEnumSet) {
      if (tmp.name().startsWith(caseProgressEnum.name()) || tmp.getCaseProgress() == caseProgressEnum) {
        result.add(tmp);
      }
    }
    return result;
  }

  public String getName() {
    return name;
  }
  
}
