/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.normandy.event.enums;

import java.util.Arrays;
import java.util.List;

public enum CaseUserTypeEnum {
    APPLICANT("\u7533\u8bf7\u4eba", "\u7533"),
    RESPONDENT("\u88ab\u7533\u8bf7\u4eba", "\u88ab"),
    APPLICANT_AGENT("\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba", "\u7533\u4ee3"),
    RESPONDENT_AGENT("\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba", "\u88ab\u4ee3"),
    MEDIATOR("\u8c03\u89e3\u5458", ""),
    ORG_MANAGE("\u673a\u6784\u7ba1\u7406\u5458", ""),
    APP_LITIGANT_AGENT("\u7533\u8bf7\u4eba\u6cd5\u5b9a\u4ee3\u8868\u4eba", ""),
    RES_LITIGANT_AGENT("\u88ab\u7533\u8bf7\u4eba\u6cd5\u5b9a\u4ee3\u8868\u4eba", ""),
    APPLICANT_AGENT_GENERAL("\u7533\u8bf7\u4eba\u4e00\u822c\u4ee3\u7406\u4eba", ""),
    APPLICANT_AGENT_PRIVILEGED("\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    APPLICANT_AGENT_JUVENILES("\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    APPLICANT_AGENT_PSYCHOTIC("\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    RESPONDENT_AGENT_GENERAL("\u88ab\u7533\u8bf7\u4eba\u4e00\u822c\u4ee3\u7406\u4eba", ""),
    RESPONDENT_AGENT_PRIVILEGED("\u88ab\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    RESPONDENT_AGENT_JUVENILES("\u88ab\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    RESPONDENT_AGENT_PSYCHOTIC("\u88ab\u7533\u8bf7\u4eba\u7279\u6743\u4ee3\u7406\u4eba", ""),
    PETITION_AGENT("\u4fe1\u8bbf\u4ee3\u7406\u4eba", ""),
    GENERAL_AGENT("\u4e00\u822c\u4ee3\u7406\u4eba", ""),
    PRIVILEGE_AGENT("\u7279\u6743\u4ee3\u7406\u4eba", ""),
    JUVENILES("\u672a\u6210\u5e74\u4eba", ""),
    PSYCHOTIC("\u65e0\u6c11\u4e8b\u884c\u4e3a\u80fd\u529b\u3001\u9650\u5236\u6c11\u4e8b\u884c\u4e3a\u80fd\u529b\u7684\u7cbe\u795e\u75c5\u4eba", ""),
    MEDIATOR_HELP("\u534f\u52a9\u8c03\u89e3\u5458", ""),
    MEDIATOR_HELP_TEMPORARY("\u4e34\u65f6\u534f\u52a9\u8c03\u89e3\u5458", ""),
    LITIGANT("\u5f53\u4e8b\u4eba", "?"),
    ARBITRATOR("\u4ef2\u88c1\u5458", ""),
    SECRETARY("\u529e\u6848\u79d8\u4e66", ""),
    CLERK("\u4e66\u8bb0\u5458", "\u4e66\u8bb0\u5458"),
    RECORDER("\u8bb0\u5f55\u4eba\u5458", ""),
    APPLY_CASE("\u7acb\u6848\u5458", ""),
    JUROR("\u966a\u5ba1\u5458", "\u966a\u5ba1\u5458"),
    JUDGE("\u6cd5\u5b98", "\u6cd5\u5b98"),
    LINESMAN("\u8fb9\u88c1", ""),
    ASSISTANT_JUDGE("\u6cd5\u5b98\u52a9\u7406", "\u6cd5\u52a9"),
    LITIGANT_WITNESS("\u8bc1\u4eba", "\u8bc1\u4eba"),
    LITIGANT_THIRD("\u7b2c\u4e09\u4eba", "\u7b2c\u4e09\u4eba"),
    INVITATION_WATCHER("\u89c2\u6469\u4eba", ""),
    INVITATION_WATCHER_NO_PICTURE("\u89c2\u6469\u4eba\u65e0\u753b\u9762", ""),
    PARTICIPANTS("\u53c2\u4e0e\u4eba", ""),
    APPLICANT_SIDE("\u7533\u8bf7\u65b9", ""),
    RESPONDENT_SIDE("\u88ab\u7533\u8bf7\u65b9", ""),
    PLATFORM_LEADER("\u5e73\u53f0\u8d1f\u8d23\u4eba", ""),
    DIVISION_LEADER("\u5206\u6848\u5458", ""),
    ZONG_DISPUTE("\u7efc\u7a97\u5904\u7f6e\u5458", ""),
    ZHUAN_DISPUTE("\u4e13\u7a97\u5904\u7f6e\u5458", "");

    private final String name;
    private final String desc;

    private CaseUserTypeEnum(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Boolean isClient(String e) {
        return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e);
    }

    public static Boolean isApplicant(String e) {
        return APPLICANT.name().equals(e) || APPLICANT_AGENT.name().equals(e);
    }

    public static boolean isRespondent(String userType) {
        return RESPONDENT.name().equals(userType) || RESPONDENT_AGENT.name().equals(userType);
    }

    public static boolean isMediator(String userType) {
        return MEDIATOR.name().equals(userType);
    }

    public static boolean isMediatorHelp(String userType) {
        return MEDIATOR_HELP.name().equals(userType);
    }

    public static boolean isMediatorOrHelp(String userType) {
        return CaseUserTypeEnum.isMediator(userType) || CaseUserTypeEnum.isMediatorHelp(userType);
    }

    public static Boolean isAgent(String caseUserType) {
        return caseUserType.endsWith("_AGENT");
    }

    public static Boolean isLitigantUser(String meetingUserType) {
        return LITIGANT.name().equalsIgnoreCase(meetingUserType) || APPLICANT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT.name().equalsIgnoreCase(meetingUserType) || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType) || LITIGANT_WITNESS.name().equalsIgnoreCase(meetingUserType) || LITIGANT_THIRD.name().equalsIgnoreCase(meetingUserType);
    }

    public static Boolean isMediatorUser(String meetingUserType) {
        return MEDIATOR.name().equalsIgnoreCase(meetingUserType) || MEDIATOR_HELP.name().equalsIgnoreCase(meetingUserType) || MEDIATOR_HELP_TEMPORARY.name().equalsIgnoreCase(meetingUserType) || JUDGE.name().equalsIgnoreCase(meetingUserType) || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType) || CLERK.name().equalsIgnoreCase(meetingUserType) || JUROR.name().equalsIgnoreCase(meetingUserType);
    }

    public static Boolean isMeetingMediatorUser(String meetingUserType) {
        return MEDIATOR.name().equalsIgnoreCase(meetingUserType) || JUDGE.name().equalsIgnoreCase(meetingUserType) || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType) || CLERK.name().equalsIgnoreCase(meetingUserType) || JUROR.name().equalsIgnoreCase(meetingUserType);
    }

    public static CaseUserTypeEnum getCaseUserType(String caseUserType) {
        return Arrays.stream(CaseUserTypeEnum.values()).filter(switchEnum -> switchEnum.toString().equals(caseUserType)).findFirst().orElse(null);
    }

    public static List<String> getMediatorUserEnumName() {
        return Arrays.asList(MEDIATOR.name(), JUDGE.name(), ASSISTANT_JUDGE.name(), CLERK.name(), JUROR.name());
    }

    public static List<String> getSizeName() {
        return Arrays.asList(APPLICANT_SIDE.name(), RESPONDENT_SIDE.name());
    }

    public static Boolean isEvaluate(String meetingUserType) {
        return APPLICANT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT.name().equalsIgnoreCase(meetingUserType) || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType) || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType) || APP_LITIGANT_AGENT.name().equalsIgnoreCase(meetingUserType) || RES_LITIGANT_AGENT.name().equalsIgnoreCase(meetingUserType);
    }
}

