package com.beiming.odr.document.api;

import com.beiming.odr.document.dto.requestdto.ObjectBizRoomReqDTO;
import com.beiming.odr.document.dto.responsedto.SuspectFileResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.document.dto.requestdto.BatchFilesReqDTO;
import com.beiming.odr.document.dto.requestdto.DelFileByFileIdReqDTO;
import com.beiming.odr.document.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.document.dto.requestdto.IdReqDTO;
import com.beiming.odr.document.dto.requestdto.ObjectMicroReqDTO;
import com.beiming.odr.document.dto.requestdto.ObjectReqDTO;
import com.beiming.odr.document.dto.requestdto.ShareDocReqDTO;
import com.beiming.odr.document.dto.requestdto.UploadFileReqDTO;
import com.beiming.odr.document.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.document.dto.responsedto.DocAttachmentResDTO;

/**
 * Created by zli on 2019/2/22.
 *
 * 附件
 */
@Valid
public interface AttachmentApi {

  /**
   * 批量保存材料文件
   */
  DubboResult batchSaveFile(@Valid BatchFilesReqDTO batchFilesReqDTO);

  /**
   * 保存单个文件
   */
  DubboResult<Long> uploadFile(UploadFileReqDTO reqDTO);

  /**
   * 附件单个获取
   */
  DubboResult<DocAttachmentResDTO> getAttachment(@Valid IdReqDTO docIdReqDTO);

  DubboResult<DocAttachmentResDTO> getAttachmentByFileId(@Valid String fileId);

  /**
   * 删除
   */
  DubboResult<Boolean> delAttachment(@Valid DelFileReqDTO delFileReqDTO);

  /**
   * 删除
   */
  DubboResult<Boolean> delAttachmentByFileId(@Valid DelFileByFileIdReqDTO delFileReqDTO);

  /**
   * 列表
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> queryAttachmentList(@Valid ObjectReqDTO reqDTO);
  DubboResult<ArrayList<DocAttachmentResDTO>> queryAllAttachmentList(@Valid ObjectBizRoomReqDTO reqDTO);
  DubboResult<ArrayList<DocAttachmentResDTO>> getGzzcOtherBooks(@Valid ObjectReqDTO reqDTO);

  DubboResult<Integer> queryAttachmentNum(ObjectReqDTO reqDTO);

  /**
   * 查询附件列表,包含是否确认
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> queryAttachmentInfoList(
      @Valid AttachmentListReqDTO reqDTO);

  /**
   * 查询文件列表
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> queryDocAttachmentList(
      @Valid AttachmentListReqDTO reqDTO);

  /**
   * 查询文件列表
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> getAttachmentList(@Valid AttachmentListReqDTO reqDTO);

  /**
   * 根据附件ids获取案件附件列表 attachmentIds  1,2,3
   */
  DubboResult<ArrayList<CaseMaterialResDTO>> getLawAttachmentByIds(
      @Valid @NotBlank(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL) String attachmentIds);


  /**
   * <pre>
   * 分享文书给其他在线庭审成员查看操作
   * 逻辑是在表doc_attachment字段share_meeting_id中保存分享目标庭审ID
   */
  @SuppressWarnings("rawtypes")
  DubboResult shareDoc(@Valid ShareDocReqDTO dto);


  /**
   * 关联roomId的文书列表(微庭审用)
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> queryAttachmentListMicro(@Valid ObjectMicroReqDTO reqDTO);

  /**
   * 根据fileId获取文书
   */
  DubboResult<DocAttachmentResDTO> getDocAttachmentByFileId(@Valid String fileId);



  /**
   * 根据案件id获取质证报告 信息
   */
  DubboResult<SuspectFileResDTO> getSuspectFile(Long bizRoomId);

  /**
   * 更改状态为 USED
   * @param id
   * @return
   */
  DubboResult<Boolean> updateAttachmentStatusById(Long id);

  DubboResult<DocAttachmentResDTO> getAttachmentById(@Valid Long id);

  DubboResult<Boolean> updateExamineFlagById(Long id, String examineFlag);

  /**
   * 根据文件id查找对应的文书信息
   * @param ids
   * @return
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> getAttachmentByDocIds(ArrayList<Long> ids);
}
