package com.beiming.odr.document.api;

import java.util.ArrayList;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.AddAttachmentEvidenceReqDTO;
import com.beiming.odr.document.dto.requestdto.DeleteAttachmentEvidenceReqDTO;
import com.beiming.odr.document.dto.requestdto.GetAttachmentEvidenceReqDTO;
import com.beiming.odr.document.dto.requestdto.SubmitAttachmentEvidenceReqDTO;
import com.beiming.odr.document.dto.responsedto.AttachmentEvidenceResDTO;
import com.beiming.odr.document.dto.responsedto.GetAttachmentEvidenceResDTO;

/**
 * 材料质证
 * 
 * @author qsh
 * @date 2020年2月5日
 */
public interface AttachmentEvidenceApi {

  /**
   * 添加质证
   * 
   * @return
   */
  DubboResult<AttachmentEvidenceResDTO> addAttachmentEvidence(AddAttachmentEvidenceReqDTO reqDto);

  /**
   * 查询质证用户信息
   * 
   * @param dto
   * @return
   */
  DubboResult<GetAttachmentEvidenceResDTO> getAttachmentEvidence(GetAttachmentEvidenceReqDTO dto);
  
  
  /**
   * 查询材料多个质证列表
   * 
   * @param dto
   * @return
   */
  DubboResult<ArrayList<GetAttachmentEvidenceResDTO>> queryAttachmentEvidenceList(
      GetAttachmentEvidenceReqDTO dto);
  
  /**
   * 添加质证
   * @param reqDto
   * @return
   */
  DubboResult<AttachmentEvidenceResDTO> submitAttachmentEvidence(
      SubmitAttachmentEvidenceReqDTO reqDto);
  
  DubboResult deleteEvidence(DeleteAttachmentEvidenceReqDTO deleteAttachmentEvidence);

}
