package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.dto.requestdto.ClerkConfirmPerReqDTO;
import com.beiming.odr.document.dto.requestdto.SignatureConfirmInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.ClerkConfirmPerResDTO;
import com.beiming.odr.document.dto.responsedto.DocPersonConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureConfirmInfoResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 文书签名状态API
 *
 * @author DJQ 2018年6月27日
 */
@Valid
public interface ClerkConfirmApi {

  /**
   * 查询某用户对调解文书的签名状态
   */
  DubboResult<ClerkConfirmPerResDTO> getMediationClerkConfirm(@Valid ClerkConfirmPerReqDTO reqDTO);

  /**
   * 查询调解文书的各方签名状态
   */
  DubboResult<ArrayList<DocPersonConfirmResDTO>> getAllMediationClerkConfirm(
      @Valid @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL) Long docId);

  /**
   * 签名确认结果信息
   */
  DubboResult<ArrayList<SignatureConfirmInfoResDTO>> signatureConfirmInfo(
      @Valid SignatureConfirmInfoReqDTO reqDTO);

}
