package com.beiming.odr.document.api;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveDocBookReqDTO;
import com.beiming.odr.document.dto.responsedto.DocTemplateSignResDTO;
import com.beiming.odr.document.dto.responsedto.SendDocBookResDTO;

/**
 * 文书
 */
@Valid
public interface DocBookApi {

  /**
   * 发送文书
   */
  DubboResult<SendDocBookResDTO> sendDocBook(SaveDocBookReqDTO reqDTO);

  /**
   * 根据文书类型查询文书模板中签名标识
   */
  DubboResult<ArrayList<DocTemplateSignResDTO>> queryDocTemplateSign(String docType);
  
  DubboResult addMeetingPersonDoc(List<DocPersonReqDTO> docPersonList, Long meetingId, List<Long> userList);

}
