package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveDocBookReqDTO;
import com.beiming.odr.document.dto.responsedto.SendDocBookResDTO;

import java.util.Map;

/**
 * 四川仲裁
 */
public interface DocBookSczcApi {

  /**
   * 发送文书
   *
   * @param saveDocBookReqDTO
   * @return
   */
  DubboResult<SendDocBookResDTO> sendDocBook(SaveDocBookReqDTO saveDocBookReqDTO);

  /**
   * 生成送达回证文书
   *
   * @param dataMap
   */
  DubboResult<String> createSendReceipt(Map<String, Object> dataMap);

  /**
   * 保存草稿文件
   *
   * @param saveDocBookReqDTO
   * @return
   */
  DubboResult<SendDocBookResDTO> saveDraftDocBook(SaveDocBookReqDTO saveDocBookReqDTO);

  /**
   * 通过docId更新文件ID
   *
   * @param docId
   * @param fileId
   */
  void updateDocBookFileIdById(Long docId, String fileId);
}
