package com.beiming.odr.document.api;

import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocDissentGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocDissentSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocDissentGetResDTO;
import com.beiming.odr.document.dto.responsedto.DocDissentSaveResDTO;

/**
 * 异议书API DISSENT_RECORD
 *
 * @author DJQ
 */
@Valid
public interface DocDissentApi {

  /**
   * 获取异议书
   *
   * @return
   */
  DubboResult<DocDissentGetResDTO> getDocDissent(@Valid DocDissentGetReqDTO reqDTO);

  /**
   * 保存异议书
   *
   * @return
   */
  DubboResult<DocDissentSaveResDTO> saveDocDissent(@Valid DocDissentSaveReqDTO reqDTO);

  /**
   * 发送异议书
   *
   * @return
   */
  DubboResult<DocDissentSaveResDTO> sendDocDissent(@Valid DocDissentSaveReqDTO reqDTO);

}
