package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DeliveryRequestDTO;
import com.beiming.odr.document.dto.requestdto.MemberRequestDTO;
import com.beiming.odr.document.dto.responsedto.DossierAttachment;
import com.beiming.odr.document.dto.responsedto.ElectronicConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicDeliveryResDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

/**
 * 卷宗材料API
 *
 * @author sunzheng
 */
@Valid
public interface DocDossierApi {


  void saveDossier(DossierAttachment dto);

  void deleteDossier(DossierAttachment dossierAttachment);

  void updateDossierSort(DossierAttachment dossierAttachment);

  ArrayList<ElectronicDeliveryResDTO> signatureStatus(DeliveryRequestDTO deliveryRequestDTO);

  DubboResult<ElectronicDeliveryResDTO> electronicDocInfo(DeliveryRequestDTO dto);

  DubboResult<ElectronicConfirmResDTO> confirmDocInfo(ElectronicDeliveryResDTO dto);

  /**
   * 插入电子送达确认书
   *
   * @param subjectId   对象id
   * @param signUserIds 用户id标志
   */
  boolean insertElectronicDoc(String subjectId, List<MemberRequestDTO> signUserIds);


  /**
   * 选择档案目录
   *
   * @param meetingId 会议id
   * @return {@link List}<{@link DossierAttachment}>
   */
  List<DossierAttachment> selectDossierCatalogue(Long meetingId);


  Map<String, Object> signatureConfirmInfo(ElectronicDeliveryResDTO dto);
}
