package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.document.dto.responsedto.JudicialConfirmBookResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 司法申请书 JUDICIAL_CONFIRM_APPLY_BOOK
 */
@Valid
public interface DocJudicialConfirmApplyBookApi {

  /**
   * 调解员获取司法确认申请书
   */
  DubboResult<JudicialConfirmBookResDTO> getJudicialBookByMediator(Long objId);

  /**
   * 用户获取司法确认申请书
   */
  DubboResult<JudicialConfirmBookResDTO> getJudicialBookByUser(Long objId);

  /**
   * 保存司法确认申请书
   */
  DubboResult<Long> saveJudicialBook(SaveJudicialConfirmBookReqDTO reqDTO);

  /**
   * 发送司法确认申请书
   */
  DubboResult<Long> sendJudicialBook(SaveJudicialConfirmBookReqDTO reqDTO);

}
