package com.beiming.odr.document.api;

import java.util.ArrayList;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocSignListReqDTO;
import com.beiming.odr.document.dto.requestdto.ReplaceDocReqDTO;
import com.beiming.odr.document.dto.responsedto.DocSignListResDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;

/**
 * Created by zli on 2019/2/22.
 *
 * 文书列表
 */
@Valid
public interface DocListApi {
  /**
   * 用户待确认文书列表<br>
   * 一键签名文书列表<br>
   * 案件/调解室/视频已签署文书列表<br>
   * 案件/调解室/视频未签署文书列表<br>
   */


  /**
   * 签署文书列表
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<DocSignListResDTO>> signDocList(DocSignListReqDTO reqDTO);
  
  /**
   * 根据objectId查询文书列表
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<DocSignListResDTO>> getDocByObject(Long objectId);
  
  /**
   * 根据objectId及docid查询用户签字文件
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<DocWholeConfirmResDTO>> getUserSignFile(Long docId);
  
  /**
   * 根据docid替换文书id
   * @param replaceDocReq
   * @return
   */
  DubboResult replaceDocFileId(ReplaceDocReqDTO replaceDocReq);
  

}
