package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveMediationBookReqDTO;
import com.beiming.odr.document.dto.responsedto.MediationBookResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 调解协议书 MEDIATION_BOOK
 */
@Valid
public interface DocMediationBookApi {

  /**
   * 调解员获取调解协议书
   */
  DubboResult<MediationBookResDTO> getMediationBookByMediator(Long objId);

  /**
   * 用户获取调解协议书
   */
  DubboResult<MediationBookResDTO> getMediationBookByUser(Long objId);

  /**
   * 保存调解协议书
   */
  DubboResult<Long> saveMediationBook(SaveMediationBookReqDTO reqDTO);
}
