package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveMediationSchemeReqDTO;
import com.beiming.odr.document.dto.responsedto.MediationSchemeResDTO;
import com.beiming.odr.document.dto.responsedto.MediatorMediationSchemeResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 无异议调解方案 NO_DISSENT_MEDIATION_SCHEME
 */
@Valid
public interface DocMediationSchemeApi {

  /**
   * 调解员获取无异议调解方案
   */
  DubboResult<MediatorMediationSchemeResDTO> getMediationSchemeByMediator(Long objId);

  /**
   * 用户获取无异议调解方案
   */
  DubboResult<MediationSchemeResDTO> getMediationSchemeByUser(Long objId);

  /**
   * 保存无异议调解方案
   */
  DubboResult<Long> saveMediationScheme(SaveMediationSchemeReqDTO reqDTO);
}
