package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.DockingDocMqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import com.beiming.odr.document.dto.responsedto.ReportResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 调解/调查笔录 MEDIATION_RECORD/INQUIRE_RECORD
 */
@Valid
public interface DocRecordApi {

  /**
   * 获取已经发送的笔录
   * 
   * @param reqDTO
   * @param isNew true:SEND_NO;false:SEND_YES;
   * @return
   */
  DubboResult<DocRecordGetResDTO> getDocRecord(@Valid DocRecordGetReqDTO reqDTO, Boolean isNew);

  /**
   * 发送笔录
   */
  DubboResult<DocIdResDTO> sendDocRecord(@Valid DocRecordSaveReqDTO reqDTO);

  /**
   * 保存笔录
   */
  DubboResult<DocIdResDTO> saveDocRecord(@Valid DocRecordSaveReqDTO reqDTO);

  /**
   * 查询笔录
   * 
   * @param idList
   * @return
   */
  List<Long> getBiku(List<Long> ids);


  /**
   * 获取质证报告和电子送达报告
   *
   * @return
   */
  DubboResult<ArrayList<ReportResDTO>> getReport(Long bizRoomId);


  /**
   * 案件结束对接同步湖北数据中的数据接口
   *
   * @return
   */
  void sendAllMaterialsTdhNew(DockingDocMqDTO dockingDocMqDTO);
}
