package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 调解/调查笔录 MEDIATION_RECORD/INQUIRE_RECORD
 */
@Valid
public interface DocRecordGzzcApi {
  
  /**
   * 获取已经发送的笔录
   * 
   * @param reqDTO
   * @param isNew true:SEND_NO;false:SEND_YES;
   * @return
   */
  DubboResult<DocRecordGetResDTO> getDocRecordGzzc(@Valid DocRecordGetReqDTO reqDTO, Boolean isNew);

  /**
   * 保存笔录
   */
  DubboResult<DocIdResDTO> saveDocRecordGzzc(@Valid DocRecordSaveReqDTO reqDTO);

  /**
   * 发送笔录
   */
  DubboResult<DocIdResDTO> sendDocRecordGzzc(@Valid DocRecordSaveReqDTO reqDTO);
  
  DubboResult<Long> getDocId(Long objectId);

  /**
   * 替换文书
   * @param meetingId
   * @param fileId
   * @return
   */
  DubboResult<String> replaceDocument(Long meetingId, String fileId);


}
