package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 调解/调查笔录 MEDIATION_RECORD/INQUIRE_RECORD
 */
@Valid
public interface DocRecordMicroApi {
  
  /**
   * 获取已经发送的笔录
   * 
   * @param reqDTO
   * @param isNew true:SEND_NO;false:SEND_YES;
   * @return
   */
  DubboResult<DocRecordGetResDTO> getDocRecordMicro(@Valid DocRecordGetReqDTO reqDTO, Boolean isNew);

  /**
   * 保存笔录
   */
  DubboResult<DocIdResDTO> saveDocRecordMicro(@Valid DocRecordSaveReqDTO reqDTO);

  /**
   * 发送笔录
   */
  DubboResult<DocIdResDTO> sendDocRecordMicro(@Valid DocRecordSaveReqDTO reqDTO);

  /**
   * 生成质证报告
   */
  DubboResult<DocIdResDTO> sendDocSuspectRecordMicro(@Valid DocRecordSaveReqDTO reqDTO);


  DubboResult<Long> getDocId(Long objectId);


  /**
   * 生成电子送达回证
   *
   * @param reqDTO 点播dto
   * @return {@link DubboResult}<{@link DocIdResDTO}>
   */
  DubboResult<DocIdResDTO> sendDocElectronicRecordMicro(DocRecordSaveReqDTO reqDTO);
}
